[!outputon]
unit [!UnitName];

interface
  uses System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel, System.Collections.Specialized,
  System.Drawing.Design, System.IO, Borland.Data.Web;

type
//   [ToolboxBitmap(typeof([!CustomControlName])]
//   ['[!CustomControlName].bmp')]
	[Designer('Borland.Data.Web.DBWebControlDesigner')]
	[ToolboxData('<{0}:[!CustomControlName] runat=server></{0}:[!CustomControlName]>')]
[!if=(DBWebLookUp, "TRUE")]
  [!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebLookupColumnLink)
[!else]
[!if=(DBWebColumn, "TRUE")]
  [!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebColumnLink)
[!else]
  [!CustomControlName] = class(System.Web.UI.WebControls.WebControl, IPostBackDataHandler, IDBWebDataLink)
[!endif]
[!endif]
  strict private
    // FMyDelegate: TextBox; // or whatever control or controls you want to use to render your control.
  strict protected
    // Override Render when descending directly from ASP.NET Control
    // procedure Render(Output: HtmlTextWriter); override;

    // Override RenderContents when descending from ASP.NET WebControl
    procedure RenderContents(Output: HtmlTextWriter); override;
  public
    constructor Create;
  // Implement code from this region for controls that use the DB Web interfaces
  strict protected
    procedure OnInit(e: EventArgs); override;
    procedure OnPreRender(args: EventArgs); override;
    // For more information on IPostBackDataHandler, see the help entry
    // ms-help://borland.bds2/cpref/html/frlrfSystemWebUIIPostBackDataHandlerClassLoadPostDataTopic.htm
    function LoadPostData(postDataKey: string;
      postCollection: NameValueCollection) : boolean;
    procedure RaisePostDataChangedEvent;

  // IDBWebDataLink is the core interface for the DB Web controls
  // and must be implemented for all DB Web controls

  private 
    FDataLink: DBWebDataLink;
    FIDataLink: IDBWebDataLink;
    function GetTableName: string;
    procedure SetTableName(Value: string);
    function GetDataSource: IDBDataSource;
    procedure SetDataSource(Value: IDBDataSource);
    function GetText: string;
  protected
    property Text: string read GetText;
  public
    property IDataLink: IDBWebDataLink read FIDataLink;
    procedure DataBind; override;

  published
    [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property TableName: string read GetTableName write SetTableName;
		[LocalizableCategoryAttribute('DBWebControl'),
  		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
  		DefaultValue('')]
    property DBDataSource: IDBDataSource read GetDataSource write SetDataSource;

[!if=(DBWebColumn, "TRUE")]
  {$REGION 'IDBWebColumnLink declarations'}
  // IDBWebColumnLink is used to databind to a specific column (optional)
  private // Should this be strict private?
    FIColumnLink: IDBWebColumnLink;
    function GetIColumnLink : IDBWebColumnLink;
    function GetColumnName: string;
    procedure SetColumnName(Value: string);
  public
    property IColumnLink: IDBWebColumnLink read GetIColumnLink;
  published
    [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property ColumnName: string read GetColumnName write SetColumnName;
  {$ENDREGION}
[!endif]

[!if=(DBWebLookUp, "TRUE")]
  {$REGION 'IDBWebLookupColumnLink declarations'}
  // IDBWebLookupColumnLink descends from IDBWEbColumnLink, and supports
  // properties for lookup table values
  private // Should this be strict private?
    FILookupLink: IDBWebLookupColumnLink;
    FIColumnLink: IDBWebColumnLink;
    function GetILookupLink : IDBWebLookupColumnLink;
    function GetLookupTableName: string;
    procedure SetLookupTableName(Value: string);
    function GetDataTextField: string;
    procedure SetDataTextField(Value: string);
    function GetDataValueField: string;
    procedure SetDataValueField(Value: string);
    function GetColumnName: string;
    procedure SetColumnName(Value: string);
  public
    property ILookupLink: IDBWebLookupColumnLink read GetILookupLink;
  published
    [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property LookupTableName : string read GetLookupTableName
      write SetLookupTableName;
    [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property DataTextField : string read GetDataTextField
      write SetDataTextField;
    [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property DataValueField : string read GetDataValueField
      write SetDataValueField;
    [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
  		LocalizableCategoryAttribute('DBWebControl'),
  		DefaultValue('')]
    property ColumnName: string read GetColumnName write SetColumnName;
  {$ENDREGION}
[!endif]
  end;

implementation

{$REGION 'Control.Render override'}

(*
/// <summary>
/// The override for Render should be used when descending directly from
/// System.Web.UI.WebControls.Control, or when creating a composite control
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure [!CustomControlName].Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(**)
{$ENDREGION}

{$REGION 'WebControl.RenderContents override'}
/// <summary>
/// Render this control to the output parameter specified.
/// The override for RenderContents should be used when descending from
/// System.Web.UI.WebControls.WebControl so all cosmetic attributed
/// are rendered appropriately for the control
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure [!CustomControlName].RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
{$ENDREGION}

{$REGION 'DB Web control implementation'}
// For all DB web control implementations, the IDBWebDataLink implementation
// region is required. Furthermore, the IDBWebColumnLink region is required
// for components that implement the IDBWebLookupColumnLink.
{$REGION 'IDBWebDataLink implementation'}
/// <summary>
// Construct the required private instance variables, depending on the
// defined options for this control.
/// Use this procedure if IDBWebDataLink interface is implemented
/// </summary>
constructor [!CustomControlName].Create;
begin
  inherited;
  // FMyDelegate := TextBox.Create;  // or whatever control or controls you want to render your control;
[!if=(DBWebLookUp, "TRUE")]
  FDataLink := DBWebLookupColumnLink.Create(self);
  FILookupLink := (FDatalink as IDBWebLookupColumnLink);
  FIColumnLink := (FDataLink as IDBWebColumnLink);
[!else]
[!if=(DBWebColumn, "TRUE")]
  FDataLink := DBWebColumnLink.Create(self);
  FIColumnLink := (FDataLink as IDBWebColumnLink);
[!else]
  FDataLink := DBWebDataLink.Create(self);
[!endif]
[!endif]
  // Standard DB Web interface should always be defined
  FIDataLink := (FDataLink as IDBWebDataLink);
end;

/// <summary>
/// Override the default initialization method to require postback
/// </summary>
procedure [!CustomControlName].OnInit(e: EventArgs);
begin
  inherited OnInit(e);
  if Assigned(Page) then
    Page.RegisterRequiresPostBack(self);
end;

/// <summary>
/// Register control as DBWebControl associated with a specific table
/// </summary>
procedure [!CustomControlName].OnPreRender(args: EventArgs);
begin
  inherited OnPreRender(args);
  // You need to register the hidden field to identify the key for
  // read-write controls only. Remove this call if control is read-only.
  Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + DBWebConst.Splitter
    + IDataLink.TableName, self.ID);
  DataBind;
end;

function [!CustomControlName].GetText: string;
var
  sw: StringWriter;
  tw: HtmlTextWriter;
begin
	sw := StringWriter.Create;
	tw := HtmlTextWriter.Create(sw);
	DataBind();
	// FMyDelegate.RenderControl(tw);
	Result := sw.ToString();
end;

// RaisePostDataChangedEvent is called prior to DataBind()
// DataSet and related properties are NOT available here
// Child controls are not available
function [!CustomControlName].LoadPostData(postDataKey:string;
  postCollection: NameValueCollection) : boolean;
begin
  FDataLink.LoadPostData(postDataKey, postCollection);
  // set to true if you intend to use RaisePostDataChangedEvent;
  Result := false;
end;

procedure [!CustomControlName].RaisePostDataChangedEvent;
begin
  // Put custom data change handling code here
end;

// IDBWebDataLink setters/getters
function [!CustomControlName].GetTableName: string;
begin
  Result := FIDataLink.TableName;
end;

procedure [!CustomControlName].SetTableName(Value: string);
begin
  FIDataLink.TableName := Value;
end;

function [!CustomControlName].GetDataSource: IDBDataSource;
begin
  Result := FIDataLink.DBDataSource;
end;

procedure [!CustomControlName].SetDataSource(Value: IDBDataSource);
begin
  FIDataLink.DBDataSource := Value;
end;

procedure [!CustomControlName].DataBind;
[!if=(DBWebColumn, "TRUE")]
var
  obj: System.Object;
[!endif]
begin
  try
    // DataBind whatever properties you require wherever you see
    // See the C# source code for DBWebNavigator and DBWebLabeledTextBox
    // for additional examples.

    // Set value to blank if not data bound

    // call to inherited triggers setting of DBDataSource.
		inherited DataBind;
[!if=(DBWebColumn, "TRUE")]
    if FDataLink.IsDataBound then
    begin
      obj := FIColumnLink.DBDataSource.GetColumnValue(Page,
        FIColumnLink.TableName, FIColumnLink.ColumnName);
      if Assigned(obj) then
      begin
			// FMyDelegate.Text := Convert.ToString(obj);
			  inherited DataBind;
      end
    end;
[!endif]
  except
  on E: Exception do
	begin
    if (not ClassUtils.IsDesignTime(Page)) then
				Page.Response.Write(ClassUtils.GetInternalError(Page, FIDataLink, E,
        Self.ID))
    else
		  Raise Exception(E);
  end;
end;

end;
{$ENDREGION}

[!if=(DBWebColumn, "TRUE")]
{$REGION 'IDBWebColumnLink implementation'}
function [!CustomControlName].GetIColumnLink : IDBWebColumnLink;
begin
  Result := FIColumnLink; // Could be weak referenced instead
end;

function [!CustomControlName].GetColumnName: string;
begin
  Result := IColumnLink.ColumnName;
end;

procedure [!CustomControlName].SetColumnName(Value: string);
begin
  IColumnLink.ColumnName := Value;
end;
{$ENDREGION}
[!endif]


{$REGION 'IDBWebLookupColumnLink implementation'}
[!if=(DBWebLookUp, "TRUE")]
function [!CustomControlName].GetILookupLink : IDBWebLookupColumnLink;
begin
  Result := FILookupLink; // Could be weak referenced instead
end;

function [!CustomControlName].GetLookupTableName: string;
begin
  Result := ILookupLink.LookupTableName;
end;

procedure [!CustomControlName].SetLookupTableName(Value: string);
begin
  ILookupLink.LookupTableName := Value;
end;

function [!CustomControlName].GetDataTextField: string;
begin
  Result := ILookupLink.DataTextField;
end;

procedure [!CustomControlName].SetDataTextField(Value: string);
begin
  ILookupLink.DataTextField := Value;
end;

function [!CustomControlName].GetDataValueField: string;
begin
  Result := ILookupLink.DataValueField;
end;

procedure [!CustomControlName].SetDataValueField(Value: string);
begin
  ILookupLink.DataValueField := Value;
end;
// startnew
function [!CustomControlName].GetColumnName: string;
begin
  Result := ILookupLink.ColumnName;
end;

procedure [!CustomControlName].SetColumnName(Value: string);
begin
  ILookupLink.ColumnName := Value;
end;
// endnew

[!endif]
{$ENDREGION}

{$ENDREGION}

end.

